/*!
 * @file helper_functions.h
 * @brief Definition of some minor helper-functions
*/

#ifndef _HELPER_FUNCTIONS_H
#define _HELPER_FUNCTIONS_H

#include <string>

// FORWARD DECLARATION

/***********************
*** HELPER FUNCTIONS ***
***********************/
bool          isBool(const std::string& BOOL, bool defaultValue);
int           isInt(const std::string& INT, int defaultValue);
float         isFloat(const std::string& FLOAT, float defaultValue);
const char*   isCString(const std::string& STRING, const char* defaultValue);
const std::string& isString(const std::string& STRING, const std::string& defaultValue);


int           nocaseCmp(const std::string& s1, const std::string& s2);
int           nocaseCmp(const std::string& s1, const std::string& s2, unsigned int len);


#endif /* _HELPER_FUNCTIONS_H */
