/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "RestoreStack.h"
#include "luaincl.h"

namespace OrxScript
{

  /**
   * @brief Stores the stack and the index to the top element
   *
   * @param virtualMachine the virtual machine to save
   */
  LuaRestoreStack::LuaRestoreStack (LuaVirtualMachine& virtualMachine) : savedState (NULL)
  {
    savedState = (lua_State *) virtualMachine;
    if (virtualMachine.isOk ())
    {
      savedTopIndex = lua_gettop (savedState);
    }
  }
  /**
  * @brief Restores the virtual machine
  *
  *
  */
  LuaRestoreStack::~LuaRestoreStack ()
  {
    lua_settop (savedState, savedTopIndex);
  }
}
