/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "Script.h"
#include "LuaCallback.h"
#include "luaincl.h"
#include "scriptable.h"

#include <cassert>
#include <string>
#include <iostream>
#include <stdio.h>

namespace OrxScript
{

  /**
   * @brief This function accually executes a method called by Lua.
   * @param lua Since this function gets called by lua it has to have a lua_State as parameter
   * @return the number of return values. (which can be found on the stack)
   *
   * For Lua doesn't know how to handle C++ objects it pushes the Objecttable (including the objectpointer) on top of the stack and
   * calls this function.
   *
   * @todo handle an acces to a nonexistent (deleted) object
   */
  int luaCallback (lua_State *lua)
  {

    // Locate the psudo-index for the function number
    int methodNumber = lua_upvalueindex (1);
    int returnCount = 0;

    bool functionSuccess = false;

    // Check for the "this" table
    if (lua_istable (lua, 1))
    {
      // Found the "this" table. The object pointer is at the index 0
      lua_rawgeti (lua, 1, 0);

      if (lua_islightuserdata (lua, -1))
      {
        // Found the pointer, need to cast it
        Scriptable* thisPointer = (Scriptable*) lua_touserdata (lua, -1);

        // Get the method index
        int methodIndex = (int) lua_tonumber (lua, methodNumber);

        // Reformat the stack so our parameters are correct
        // Clean up the "this" table
        lua_remove (lua, 1);
        // Clean up the thisPointer pointer
        lua_remove (lua, -1);

        //debug
        //std::cout<<thisPointer->whatIsThis()<<std::endl;

        LuaScript* originScript = NULL;

        lua_getglobal (lua, "this");

        if (lua_istable (lua, 1))
        {
          // Found the "this" table. The object pointer is at the index 0
          lua_rawgeti (lua, 1, 0);

          if (lua_islightuserdata (lua, -1))
          {
            // Found the pointer, need to cast it
            originScript = (LuaScript *) lua_touserdata (lua, -1);
          }
        }

        if(originScript == NULL)
        {//do something usefull
        }
        //debug
        // std::cout<<originScript->whatIsThis()<<std::endl;

        LuaVirtualMachine virtualMachine = originScript->getVirtualMachine();
        //debug
        //std::cout<<"test "<< thisPointer->methods(virtualMachine)<<std::endl;
        // Check that the method is correct index
        assert ((methodIndex <= thisPointer->methods(virtualMachine) ));
        // Call the class
        returnCount = thisPointer->scriptCalling ( virtualMachine, thisPointer->getFunctionAtIndex(methodIndex,virtualMachine));

        functionSuccess = true;
      }
    }

    if (functionSuccess == false)
    {
      lua_pushstring (lua, "luaCallback -> Failed to call the class function");
      lua_error (lua);
    }

    // Number of return variables
    return returnCount;
  }
}
