/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...

   Borrowed the Main code from 'Bart Vanhauwaert' (license below)
   and adopted it to my likings.
*/

/**
 * Copyright (C) 2002 Bart Vanhauwaert
 *
 * Permission to use, copy, modify, distribute and sell this software
 * for any purpose is hereby granted without fee. This license
 * includes (but is not limited to) standalone compilation or as part
 * of a larger project.
 *
 * This software is provided "as is" without express or implied warranty.
 *
 * For a full statement on warranty and terms and conditions for
 * copying, distribution and modification, please see the comment block
 * at the end of this file.
 *
 * Version 1
 *
 */

#include "directory.h"

#if not defined (__WIN32__)
 #include <sys/stat.h>
 #include <sys/types.h>
#endif
Directory::Directory(const std::string& directoryName)
  : File(directoryName), willfail(false)
{
  this->handle = 0;
  this->willfail = true;
}

Directory::~Directory()
{
}

bool Directory::open()
{
#if not defined(__WIN32__)
  if (this->handle != NULL)
    this->close();
  this->handle = opendir(this->name().c_str());
  if (!handle)
    willfail = true;
  else
  {
    willfail = false;
    dirent* entry = readdir(handle);
    if (entry)
      current = entry->d_name;
    else
      willfail = true;
  }
#else
    if (handle != INVALID_HANDLE_VALUE)
      this->close();

    // First check the attributes trying to access a non-Directory with
    // FindFirstFile takes ages
    DWORD attrs = GetFileAttributes(this->name().c_str());
    if ( (attrs == 0xFFFFFFFF) || ((attrs && FILE_ATTRIBUTE_DIRECTORY) == 0) )
    {
      willfail = true;
      return false;
    }
    std::string Full(this->name());
    // Circumvent a problem in FindFirstFile with c:\\* as parameter
    if ( (Full.length() > 0) && (Full[Full.length()-1] != '\\') )
      Full += "\\";
    WIN32_FIND_DATA entry;
    handle = FindFirstFile( (Full+"*").c_str(), &entry);
    if (handle == INVALID_HANDLE_VALUE)
    {
      willfail = true;
      return false;
    }
    else
    {
      willfail = false;
      current = entry.cFileName;
      return true;
    }
#endif

}

bool Directory::close()
{
#if not defined(__WIN32__)
  if (this->handle != NULL)
    closedir(handle);
  this->handle = NULL;
#else
  if (handle != INVALID_HANDLE_VALUE)
    FindClose(handle);
    handle = 0;
#endif
  this->willfail = true;
  this->current = "";
  return true;
}



std::string Directory::next()
{
#if not defined(__WIN32__)
  std::string prev(current);
  dirent* entry = readdir(handle);
  if (entry)
    current = entry->d_name;
  else
    willfail = true;
  return prev;

#else
  std::string prev = current;
  WIN32_FIND_DATA entry;
  int ok = FindNextFile(handle, &entry);
  if (!ok)
    willfail = true;
  else
    current = entry.cFileName;
  return current;
#endif
}


bool Directory::create()
{
#if not defined (__WIN32__)
  return (!mkdir(this->name().c_str(), 0777));
#else
  return (!CreateDirectory(this->name().c_str(), NULL));
#endif
}
