/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "dot_emitter.h"

#include "particle_system.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "debug.h"

using namespace std;


CREATE_FACTORY(DotEmitter, CL_DOT_EMITTER);

/**
 *  standard constructor
*/
DotEmitter::DotEmitter(float emissionRate, float velocity, float angle)
    : ParticleEmitter( emissionRate, velocity, angle)
{
  this->init();
}

/**
 *  constructs and loads a DotEmitter from a XML-element
 * @param root the XML-element to load from
*/
DotEmitter::DotEmitter(const TiXmlElement* root)
    : ParticleEmitter()
{
  this->init();

  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard destructor

   removes the EmitterSystem from the ParticleEngine
*/
DotEmitter::~DotEmitter ()
{
  this->setSystem(NULL);
}

/**
  @brief initializes default values of a ParitcleEmitter
*/
void DotEmitter::init()
{
  this->setClassID(CL_DOT_EMITTER, "DotEmitter");
}

void DotEmitter::emitParticles(unsigned int count) const
{
  Vector inheritVelocity = this->getVelocity() * this->inheritSpeed;

  for (unsigned int i = 0; i < count; i++)
  {
    Vector randDir = Vector(rand()-RAND_MAX/2, rand()-RAND_MAX/2, rand()-RAND_MAX/2);
    randDir.normalize();
    randDir = (Quaternion(angle + randomAngle *((float)rand()/RAND_MAX -.5), randDir)).apply(this->getAbsDirX());
    Vector velocityV = randDir.getNormalized()*this->velocity + inheritVelocity;

    // ROTATIONAL CALCULATION (this must not be done for all types of particles.)
    randDir = Vector(rand()-RAND_MAX/2, rand()-RAND_MAX/2, rand()-RAND_MAX/2);
    randDir.normalize();
    Quaternion orient = Quaternion(M_PI, randDir);
    Quaternion moment = Quaternion(this->momentum + this->momentumRandom, randDir);

    this->getSystem()->addParticle(this->getAbsCoor() + this->getVelocity()*.1*rand()/RAND_MAX,
                                   velocityV, orient, moment);

  }
}
