/*!
 * @file qt_gui_elements.h
 * @brief Definition of ...
*/

#ifndef __QT_GUI_ELEMENTS_H
#define __QT_GUI_ELEMENTS_H

#include "../gui_saveable.h"
#include <list>

// grouping
#include <QtGui/QGroupBox>
#include <QtGui/QProgressBar>
#include <QtGui/QLabel>

// events
#include <QtGui/QPushButton>

// options
#include <QtGui/QCheckBox>
#include <QtGui/QSlider>
#include <QtGui/QLineEdit>
#include <QtGui/QComboBox>

namespace OrxGui
{
  class QtGuiCheckBox : public QCheckBox, public Saveable
  {
    Q_OBJECT
  public:
    QtGuiCheckBox(const std::string& name, SaveableGroup* group, bool defaultValue = false);
    virtual ~QtGuiCheckBox() {};

    virtual void load();
    virtual void save();

  public slots:
    //    void setCheckValue(int);

  signals:
    //    void checkValueChanged();
  };

  class QtGuiSlider : public QSlider, public Saveable
  {
    Q_OBJECT

  public:
    QtGuiSlider(const std::string& name, SaveableGroup* group, int defaultValue = 0, Qt::Orientation orientation = Qt::Horizontal);
    virtual ~QtGuiSlider();

    virtual void load();
    virtual void save();

  public slots:
    //   void setSliderValue(float);

  signals:
    //    void sliderValueChanged(float);
  };


  class QtGuiComboBox : public QComboBox, public OrxGui::Saveable
  {
    Q_OBJECT

  public:
    QtGuiComboBox(const std::string& name, SaveableGroup* group, const std::string& defaultValue);

    virtual void load();
    virtual void save();
  };

  class QtGuiInputLine : public QLineEdit, public OrxGui::Saveable
  {
    Q_OBJECT

  public:
    QtGuiInputLine(const std::string& name, SaveableGroup* group, const std::string& defaultValue);

    virtual void load();
    virtual void save();
  };

}

#endif /* __QT_GUI_ELEMENTS_H */
