/***************************************************************************
                          QImageWidget.cpp  -  description
                             -------------------
    begin                : Fri Nov 17 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "q_image_widget.h"
#include <QtGui/QPainter>
#include <QtGui/QPaintEvent>

QImageWidget::QImageWidget( QWidget *parent)
             : QWidget( parent)
{
  image = QImage(); // construct a null image
  x = y = w = h = 0;
}

QImageWidget::~QImageWidget()
{
}

void QImageWidget::setImage(const QImage& newimage)
{
  this->image = newimage.copy();
  w = this->image.width();
  h = this->image.height();
  this->setMinimumSize(w, h);
}

void QImageWidget::paintEvent( QPaintEvent *e )
{
  if( !image.isNull() )
  {
    QPainter p;
    p.begin(this);
    p.setClipRect(e->rect());
    p.drawLine(0,0,100,100);
    p.drawImage(QPoint(0,0), this->image);
    p.end();
    /*
    QPainter painter(this);
    painter.setClipRect(e->rect());
    painter.drawImage(QPoint(0,0), image);
    */
  }
}

void QImageWidget::setGeometry(int nx, int ny, int nw, int nh)
{
  x = nx;
  y = ny;
  w = nw;
  h = nh;
  move(x,y);
  resize(w,h);
  repaint(0,0,w,h);
}
