/*!
  \file gui_video.h
  \brief File that holds the class that creates the Video-Options.
*/
#ifndef _GUI_VIDEO_H
#define _GUI_VIDEO_H

#include "../gui_element.h"
#include <vector>
#include <string>
#include <QtGui/QGroupBox>

namespace OrxGui
{
  //! Class that creates the Video-Options.
  class GuiVideo : public OrxGui::Element, public QGroupBox
  {
  public:
    GuiVideo(OrxGui::Gui* gui);
    virtual ~GuiVideo();

  private:
    void getResolutions(std::vector<QString>& resolutionList);
  };

  class GuiAdvancedVideo : public OrxGui::Element, public QGroupBox
  {
    public:
      GuiAdvancedVideo(OrxGui::Gui* gui);
      virtual ~GuiAdvancedVideo();
  };
}

#endif /* _GUI_VIDEO_H */
