/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "gui_general.h"

#include <QtGui/QLayout>
#include <QtGui/QFileDialog>

#include "debug.h"
#include "globals.h"

#include "qt_gui_elements.h"

namespace OrxGui
{
  /**
   *  Creates the General-Option-Frame
  */
  GuiGeneral::GuiGeneral(OrxGui::Gui* gui)
      : Element(CONFIG_SECTION_GENERAL, gui), QGroupBox()
  {
    QGridLayout* layout = new QGridLayout(this);
    {
      QLabel* dataDirLabel = new QLabel("DataDirectory");
      layout->addWidget(dataDirLabel, 0,0);
      this->dataDir = new QtGuiInputLine(CONFIG_NAME_DATADIR, this, DEFAULT_DATA_DIR);
      layout->addWidget(dataDir, 0, 1, 1, 2);
      QPushButton* dataFileDialogButton = new QPushButton("browse");
      layout->addWidget(dataFileDialogButton, 0, 3, 1, 1);
      connect(dataFileDialogButton, SIGNAL(released()), this, SLOT(openDataFileDialog()));


      QLabel* debugLabel = new QLabel("debug-mode");
      layout->addWidget(debugLabel, 1,0);
      QtGuiComboBox* debug = new QtGuiComboBox(CONFIG_NAME_DEBUG_LEVEL, this, "3 - information");
      layout->addWidget(debug, 1, 1, 1, 2);

      debug->addItem("0 - minimal");
#if DEBUG >=1
      debug->addItem("1 - errors");
#endif
#if DEBUG >=2
      debug->addItem("2 - warnings");
#endif
#if DEBUG >=3
      debug->addItem("3 - information");
#endif
#if DEBUG >=4
      debug->addItem("4 - debug");
#endif
#if DEBUG >=5
      debug->addItem("5 - extremely debug");
#endif
    }
  }

  /**
   *  Destructs the General-stuff
  */
  GuiGeneral::~GuiGeneral()
  {
    // nothing to do here.
  }

  void GuiGeneral::openDataFileDialog()
  {
    QString browsePath = this->dataDir->text();
    if (browsePath.isEmpty())
      browsePath = ".";

    QString s = QFileDialog::getOpenFileName(
                  this,
                  "Choose the ORXONOX DATA DIRECTORY",
                  browsePath,
                  "ORXONOX DATA INDEX (" DEFAULT_DATA_DIR_CHECKFILE ")" );

    s.remove("data.oxd");
    if (!s.isNull())
      this->dataDir->setText(s);
  }


}
