/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "gui_control.h"

#include <QtGui/QLayout>
#include "globals.h"
#include "debug.h"
#include "qt_gui_elements.h"

#include "lib/event/key_mapper.h"
#include "lib/event/key_names.h"

namespace OrxGui
{
  /**
   *  Creates the Control-Option-Frame
  */
  GuiControl::GuiControl(OrxGui::Gui* gui)
      : Element(CONFIG_SECTION_CONTROL, gui), QGroupBox()
  {
    QGridLayout* layout = new QGridLayout(this);

    {
      //QLabel* keyLabel = new QLabel;

      const KeyMapper::KeyMapping* map = KeyMapper::getKeyMapping();
      unsigned int i = 0;
      while(!map->pName.empty())
      {
        QLabel* label = new QLabel(QString().fromStdString(map->pName));
        layout->addWidget(label, i, 0);

        GuiControlInput* input = new GuiControlInput(map->pName, this, EVToKeyName(map->defaultValue));
        layout->addWidget(input, i, 1);

        ++map;
        ++i;
      }
    }


  }

  /**
   *  Destructs the Control-stuff
  */
  GuiControl::~GuiControl()
  {
    // nothing to do here.
  }

  GuiControlInput::GuiControlInput(const std::string& name, SaveableGroup* group, const std::string& defaultValue)
      : QPushButton(QString().fromStdString(name)), Saveable(name, group, defaultValue)
  {
  }

  void GuiControlInput::load()
  {
    Saveable::load();
    this->setText(QString().fromStdString(this->value().getString()));
  }
  void GuiControlInput::save()
  {
    this->value() = this->text().toStdString();
    Saveable::save();
  }


}
