/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "gui.h"
#include "gui_saveable.h"
#include "preferences.h"

namespace OrxGui
{


  /**
   * standard constructor
  */
  Gui::Gui ()
  {
    //this->setClassID(CL_PROTO_ID, "Gui");
    this->state = Gui::Null;
  }


  /**
   * standard deconstructor
  */
  Gui::~Gui ()
  {
    // delete what has to be deleted here
  }


  void Gui::loadAll()
  {
    std::vector<SaveableGroup*>::iterator loadElem;
    for (loadElem = this->groups.begin(); loadElem != this->groups.end(); ++loadElem)
    {
      (*loadElem)->load();
    }

  }

  void Gui::saveAll()
  {
    std::vector<SaveableGroup*>::iterator saveElem;
    for (saveElem = this->groups.begin(); saveElem != this->groups.end(); ++saveElem)
    {
      (*saveElem)->save();
    }

    Preferences::getInstance()->save();
  }

  /**
   * @brief adds a SaveableGroup
   * @param saveableGroup the SaveableGroup to add to the SaveList.
   */
  void Gui::addSaveableGroup(SaveableGroup* saveableGroup)
  {
    if (std::find (this->groups.begin(), this->groups.end(), saveableGroup) == this->groups.end())
      this->groups.push_back(saveableGroup);
  }

  /**
   * @brief removes a SaveableGroup
   * @param saveableGroup the SaveableGroup to remove from the SaveList.
   */
  void Gui::removeSaveableGroup(SaveableGroup* saveableGroup)
  {
    std::vector<SaveableGroup*>::iterator delElem = std::find (this->groups.begin(), this->groups.end(), saveableGroup);
    if (delElem != this->groups.end())
      this->groups.erase(delElem);
  }

  void Gui::quitEvent()
  {
    this->state |= Gui::Quitting;
  }

  void Gui::startEvent()
  {
    this->state |= Gui::Starting;
  }
}
