/*!
 * @file gui_saveable.h
 * @brief Definition of ...
*/

#ifndef _GUI_SAVEABLE_H
#define _GUI_SAVEABLE_H

#include "base_object.h"
#include "lib/util/multi_type.h"
#include <vector>

// FORWARD DECLARATION
namespace OrxGui
{
  class Gui;
  class SaveableGroup;

  //! A class for Elements in the Gui that are Saveable.
  class Saveable : public BaseObject
  {
  public:
    virtual ~Saveable();

    void makeSaveable();

    virtual void load();
    virtual void save();

    MultiType&       value() { return this->_value; };
    const MultiType& value() const { return this->_value; };
    MultiType&       defaultValue() { return this->_defaultValue; };
    const MultiType& defaultValue() const { return this->_defaultValue; };
    bool             isSaveable() const { return this->bSaveable; };

  protected:
    Saveable(const std::string& optionName, SaveableGroup* group, const MultiType& defaultValue);
    virtual void makingElementSaveable() {};

  private:
    SaveableGroup*  group;
    MultiType       _value;
    MultiType       _defaultValue;
    bool            bSaveable;
  };



  class SaveableGroup : public BaseObject
  {
  public:
    virtual ~SaveableGroup();

    void addSaveable(Saveable* saveable);
    void removeSaveable(Saveable* saveable);

    virtual void load();
    virtual void save();

  protected:
    SaveableGroup(const std::string& name, OrxGui::Gui* gui);

  private:
    OrxGui::Gui*                        gui;
    std::vector<Saveable*>              saveables;
  };

}
#endif /* _GUI_SAVEABLE_H */
