#ifndef __SCRIPTABLE_H__
#define __SCRIPTABLE_H__

#include <string>
#include <map>
#include <list>

#include "VirtualMachine.h"

namespace OrxScript
{
  class LuaScript;

  //internal representation of a LuaScript
  struct Script
  {
    int lastMethodIndex;
    int methodBase;
    int thisReference;
    LuaScript* script;
    int scriptReference; // reference to the script in its own lua_State
    std::map<int, std::string> functionMap;
  };

  class Scriptable
  {
    friend class LuaScript;

  public:
    Scriptable (void);
    virtual ~Scriptable (void);

    // Method indexing check
    int methods (LuaVirtualMachine& virtualMachine);
    //int methods(){;return 1;} //BAD BAD HACK HACK HACK !!!!!!!!!!!!!!

    char whatIsThis();

    // When the script calls a class method, this is called
    virtual int scriptCalling (LuaVirtualMachine& vm, std::string functionName) = 0;

    // When the script function has returns
    virtual void handleReturns (LuaVirtualMachine& vm, const std::string& strFunc) = 0;

    std::string getFunctionAtIndex(int index, LuaVirtualMachine& virtualMachine);

  protected:
    void registerFunction(std::string functionName);//Adds a function to the internal function list
  private:
    bool scriptableAdded(LuaScript* script, int scriptRef, int reference);
    //void scriptableFunctionAdded(LuaScript* script, int reference);


    Script* getScriptByPointer(LuaScript* script);
    Script* getScriptByVirtualMachine(LuaVirtualMachine& virtualMachine);
    std::map<int, std::string>* getFunctionMapByPointer(LuaScript* scriptPointer);
    int getLastMethodIndexByPointer(LuaScript* script);


    bool scriptIsInScriptList(LuaScript* script);

    void scriptDeleted(LuaScript* deleted);



    std::list<std::string> functionList;
    std::list<Script> scriptList;
  };

}

#endif // __SCRIPTABLE_H__
