/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "This.h"
#include "luaincl.h"

namespace OrxScript
{
  LuaThis::LuaThis (LuaVirtualMachine& vm, int iRef) : oldReference (0), virtualMachine (vm)
  {
    lua_State *state = (lua_State *) vm;
    if (vm.isOk ())
    {
      // Save the old "this" table
      lua_getglobal (state, "this");
      oldReference = luaL_ref (state, LUA_REGISTRYINDEX);

      // replace it with our new one
      lua_rawgeti(state, LUA_REGISTRYINDEX, iRef);
      lua_setglobal (state, "this");
    }
  }

  LuaThis::~LuaThis (void)
  {
    lua_State *state = (lua_State *) virtualMachine;
    if (oldReference > 0 && virtualMachine.isOk ())
    {
      // Replace the old "this" table
      lua_rawgeti(state, LUA_REGISTRYINDEX, oldReference);
      lua_setglobal (state, "this");
      luaL_unref (state, LUA_REGISTRYINDEX, oldReference);
    }
  }
}
