#ifndef __LUA_SCRIPT_BASE_H__
#define __LUA_SCRIPT_BASE_H__

#include <string>

#include "VirtualMachine.h"
#include "scriptable.h"

namespace OrxScript
{

  struct Scrptbl
  {
    Scriptable* scriptable;
    int scriptableRef;
  };

  class LuaScript
  {
  public:
    LuaScript ();
    virtual ~LuaScript (void);


    void init(LuaVirtualMachine& vm);

    /* ------------------ Script related Functions ------------------ */

    // Compile script into Virtual Machine
    bool compileFile (const std::string& strFilename);
    bool compileBuffer (unsigned char *pbBuffer, size_t szLen);

    // Register function with Lua in the this table
    int registerFunction (const std::string& strFuncName);


    // Selects a Lua Script function to call
    bool selectScriptFunction (const std::string& strFuncName);
    void addParam (int iInt);
    void addParam (float fFloat);
    void addParam (const std::string& string);

    // Runs the loaded script
    bool run (int nReturns = 0);

    // Checks on Virtual Machine script
    bool scriptHasFunction (const std::string& strScriptName);

    // Method indexing check
    int methods (void) { return methodCount; }


    // When the script calls a class method, this is called
    virtual int scriptCalling (LuaVirtualMachine& vm, int iFunctionNumber) = 0;

    // When the script function has returns
    virtual void handleReturns (LuaVirtualMachine& vm, const std::string& strFunc) = 0;



    /* ------------------- Handle external Objects ------------------ */

    void removeFromScript(int referenceToScriptable) {}
    int addScriptableToScript(Scriptable* scriptbl,const std::string& name);  // name= name the scriptable goes by in lua
    int addFunctionToScriptable(const std::string& strFuncName, int toScriptable, int lastMethodIndex);

    //Handle the Scriptable List
    Scriptable* getScriptableByReference(int scrptblRef);
    int getReferenceByScriptable(Scriptable* scriptable);
    bool addScriptableToList(Scriptable* scriptbl, int scriptableRef);
    bool removeScriptableFromList(Scriptable* scriptable);
    bool removeScriptableFromList(int scriptable);



    /* ------------------ ... ------------------ */

    LuaVirtualMachine& getVirtualMachine (void) { return virtualMachine; }
    char whatIsThis();

  protected:
    int methodCount;
    LuaVirtualMachine virtualMachine;
    int thisReference;
    int argumentCount;
    std::string functionName;
    std::list<Scrptbl> scriptableList;
  };

}

#endif // __LUA_SCRIPT_BASE_H__
