#ifndef __LUA_VIRTUAL_MACHINE_H__
#define __LUA_VIRTUAL_MACHINE_H__

#include <string>

#include "luaincl.h"
namespace OrxScript
{
  class LuaVirtualMachine
  {
  public:
    LuaVirtualMachine (void);
    virtual ~LuaVirtualMachine (void);

    bool init(void);
    bool destroy (void);

    // Load and run script elements
    bool runFile (const std::string& strFilename);
    bool runBuffer (const unsigned char *pbBuffer, size_t szLen, const char *strName = NULL);

    // C-Api into script
    bool callFunction (int nArgs, int nReturns = 0);

    // Get the state of the lua stack (use the cast operator)
    lua_State* getState (void) const{ return luaState; }
    operator lua_State* (void) const { return luaState; }

    static void panic (lua_State *lua);

    // Check if the VM is OK and can be used still
    virtual bool isOk (void) { return machineIsOk; }

    // For debugging
    //void AttachDebugger (CLuaDebugger *dbg) { m_pDbg = dbg; }

  protected:
    lua_State* luaState;
    bool machineIsOk;
    // CLuaDebugger *m_pDbg;
  };
}
#endif
