#include <iostream>
#include <string>
#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "luaincl.h"
#include "VirtualMachine.h"
#include "Script.h"
#include "LuaCallback.h"
#include "RestoreStack.h"
#include "scriptable.h"




//HACK !!!
/**
 * @brief This function adds an object to a script so that the object is accessable from within the luascript. this function is later included in LuaScript as a method
 *
 * @param scriptable the scriptable object to add.
 * @param strObjName the name that the object goes by in the script.
 * @param luaScript  the script to which the scrtiptable is added
 *
 * @return a reference to the added object
 *
 *
 * @todo add this function as a method to LuaScript
 */


int addObjectToScript(Scriptable* scriptable, const std::string& strObjName, LuaScript& luaScript)
{

  lua_State *state = (lua_State *) (luaScript.getVirtualMachine());
  LuaVirtualMachine& virtualMachine = luaScript.getVirtualMachine();

  //if() TODO: check if strObjName isn't "this"
  if (virtualMachine.isOk ())
     {
       /*create object table*/
      // Create a reference to the "object" table and set a name for the reference. Each reference is unique

      lua_newtable (state);
      int  objRef = luaL_ref (state, LUA_REGISTRYINDEX);
      lua_rawgeti (state, LUA_REGISTRYINDEX, objRef);
      lua_setglobal (state, strObjName.c_str());


      // Save the "object" table to index 0 of the "object" table
      LuaRestoreStack rs(virtualMachine);
      lua_rawgeti (state, LUA_REGISTRYINDEX, objRef);
      lua_pushlightuserdata (state, scriptable);
      lua_rawseti (state, -2, 0);



      return objRef;
     }

}


/**
 * @brief This function adds a function to a scriptable object in the lua state so that the function is accessable from within the luascript. this function is later included in LuaScript as a method
           *
           * @param scriptableRef a reference to the scriptable object
           * @param strFuncName the name that the function goes by in the script.
           * @param luaScript  the script to which the function is added
           *
           * @returns the pseudoindex of the function (The first function added has index 0, the 2nd 1 and so on)
           *
           * @todo add this function as a method to LuaScript
 */


int addFunctionToScriptable(int scriptableRef, const std::string& strFuncName, LuaScript& luaScript)
  {
    lua_State *state = (lua_State *) (luaScript.getVirtualMachine());
    LuaVirtualMachine& vm = luaScript.getVirtualMachine();
    int iMethodIdx = -1;

    if (vm.isOk ())
    {
     /* Add function */
     LuaRestoreStack rs (vm);
     iMethodIdx = 0;
     lua_rawgeti (state, LUA_REGISTRYINDEX, scriptableRef);
     lua_pushstring (state, strFuncName.c_str());
     lua_pushnumber (state, (lua_Number) iMethodIdx);
     lua_pushcclosure (state, luaCallback, 1);
     lua_settable (state, -3);
    }

    return iMethodIdx;
  }

class objectOne : public Scriptable
{
  public:
    objectOne () : Scriptable ()
    {

    }

    int scriptCalling (LuaVirtualMachine& vm, std::string functionName)
    {
      //switch (iFunctionNumber) //- methodBase) uncomment this when methodBase gets correclty set in the Scriptable class
      if(functionName.compare("printNameOne")==0)
      {
        //case 0:
          return printNameOne (vm);
      }

      return 0;
    }


    int printNameOne(LuaVirtualMachine& vm)
    {
    std::cout<<"Hi I'm Object 1 !"<<std::endl;
    return 0;
    }

    void handleReturns (LuaVirtualMachine& vm, const std::string& strFunc)
  {

  }

};

class objectTwo : public Scriptable
{
  public:
    objectTwo () : Scriptable ()
    {
      registerFunction(std::string("printNameTwo"));
     // registerFunction(std::string("printHello"));

    }

    int scriptCalling (LuaVirtualMachine& vm, std::string functionName)
    {
      //switch (iFunctionNumber) //- m_iMethodBase) //TODO:find a way to determine the function number somehow: this works just incidentally
      if(functionName.compare("printNameTwo")==0)
      {
        //case 0:

          return printNameTwo (vm);
      }

      return 0;
    }


    int printNameTwo(LuaVirtualMachine& vm)
    {
      std::cout<<"Hi I'm Object 2 !\n"<<std::endl;
      return 0;
    }

    int printHello(LuaVirtualMachine& vm)
    {
      std::cout<<"Nice to meet you!\n"<<std::endl;
      return 0;
    }

    void handleReturns (LuaVirtualMachine& vm, const std::string& strFunc)
    {

    }

};




class CMyScript : public LuaScript
{
  public:
    CMyScript () : LuaScript ()
    {
     // m_iMethodBase = registerFunction ("hello1");
      //registerFunction ("hello2");
      //registerFunction ("hello3");
    }

    int scriptCalling (LuaVirtualMachine& vm, int iFunctionNumber)
    {
      /*switch (iFunctionNumber - m_iMethodBase)
      {
        case 0:
          return Hello1 (vm);
        case 1:
          return Hello2 (vm);
        case 2:
          return Hello3 (vm);
      }

      return 0;*/
    }

    int Hello1 (LuaVirtualMachine& vm)
    {
      printf ("Hellow (1)\n");
      return 0;
    }

    int Hello2 (LuaVirtualMachine& vm)
    {
      lua_State *state = (lua_State *) vm;

      int iNumber = (int) lua_tonumber (state, -2);
      int iNumber2 = (int) lua_tonumber (state, -1);
      printf ("Hellow (2) -> %d\n", iNumber);
      printf ("Second argument was %d\n",iNumber2);
      return 0;
    }

    int Hello3 (LuaVirtualMachine& vm)
    {
      lua_State *state = (lua_State *) vm;

      int iNumber = (int) lua_tonumber (state, -1);
      printf ("Hello (3) -> %d\n", iNumber);
      lua_pushnumber (state, iNumber + 2);
      return 1;
    }


    void handleReturns (LuaVirtualMachine& vm, const std::string& strFunc)
    {
      if (strcmp (strFunc.c_str(), "divideMe") == 0)
      {
         // frames returns an answer of the stack
        lua_State *state = (lua_State *) vm;
        int itop = lua_gettop (state);
        int iType = lua_type (state, -1);
        const char *s = lua_typename (state, iType);
        double fFrameCount = lua_tonumber (state, -1);

        printf ("frame count = %f\n", fFrameCount);
      }
    }

  protected:
    int m_iMethodBase;
};

//! main  test routine
int main (int argc, const char** argv)
{

  std::cout << "lua-testing environment\n" << std::endl;



  CMyScript ms;

  objectOne ob1;
  objectTwo ob2;
  //CMyScript ob1 (vm2);

  //addObjectToScript(&ob1, "obOne", ms, "printNameOne");
  int obTwoRef = ms.addScriptableToScript(&ob2, "object");
 // ms.addFunctionToScriptable("printNameTwo",obTwoRef,-1);

  ms.compileFile ("luascript1.lua");


  int iTopS = lua_gettop ((lua_State *) ms.getVirtualMachine());


  assert (ms.scriptHasFunction ("CountAndCall"));
  assert (!ms.scriptHasFunction ("countAndCall"));
  assert (!ms.scriptHasFunction ("test"));

  ms.selectScriptFunction ("CountAndCall");
  ms.addParam (2);
  bool res = ms.run ();
  printf("ms.run returned %b\n",res);

  /* Debug Output
  lua_State* state =  (lua_State *) (ms.vm());
  lua_Debug debug;
  //lua_getfield(state, LUA_GLOBALSINDEX, "CountAndCall" );
  lua_getinfo( state, "Sl", &debug );
  std::cout << debug.name<< std::endl;
  */

  /*ms.selectScriptFunction ("divideMe");
  ms.addParam (33);
  ms.run (1);

  ms.selectScriptFunction ("returnToMe");
  ms.addParam (10);
  ms.run (0);
  */
  return 0 ;

}
