#ifndef __THIS_H__
#define __THIS_H__

#include "VirtualMachine.h"
#include "luaincl.h"

// Sets the "this" global table that scripts use

class LuaThis
{
  public:
    LuaThis (LuaVirtualMachine& vm, int iRef) : oldReference (0), virtualMachine (vm)
    {
      lua_State *state = (lua_State *) vm;
      if (vm.isOk ())
      {
         // Save the old "this" table
        lua_getglobal (state, "this");
        oldReference = luaL_ref (state, LUA_REGISTRYINDEX);

         // replace it with our new one
        lua_rawgeti(state, LUA_REGISTRYINDEX, iRef);
        lua_setglobal (state, "this");
      }
    }

    virtual ~LuaThis (void)
    {
      lua_State *state = (lua_State *) virtualMachine;
      if (oldReference > 0 && virtualMachine.isOk ())
      {
         // Replace the old "this" table
        lua_rawgeti(state, LUA_REGISTRYINDEX, oldReference);
        lua_setglobal (state, "this");
        luaL_unref (state, LUA_REGISTRYINDEX, oldReference);
      }
    }


  protected:
    int oldReference;
    LuaVirtualMachine& virtualMachine;
};

#endif // __THIS_H__
