#ifndef __RESTORE_STACK_H__
#define __RESTORE_STACK_H__

#include "luaincl.h"

//! Class to restore the stack to the way we found it.
class LuaRestoreStack
{
public:
  /**
   * @brief Stores the stack and the index to the top element
   *
   * @param virtualMachine the virtual machine to save
   */
   LuaRestoreStack (LuaVirtualMachine& virtualMachine) : savedState (NULL)
   {
      savedState = (lua_State *) virtualMachine;
      if (virtualMachine.isOk ())
      {
         savedTopIndex = lua_gettop (savedState);
      }
   }
   /**
    * @brief Restores the virtual machine
    *
    *
    */
   virtual ~LuaRestoreStack (void)
   {
      lua_settop (savedState, savedTopIndex);
   }

protected:
   lua_State* savedState;
   int savedTopIndex;
};


#endif // __RESTORE_STACK_H__
