/*
  orxonox - the future of 3D-vertical-scrollers

  Copyright (C) 2004 orx

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
      the Free Software Foundation; either version 2, or (at your option)
      any later version.

### File Specific:
    main-programmer: Patrick Boenzli
    co-programmer:
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
          For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

#include "simple_sync.h"

#include "class_id.h"
#include "fast_factory.h"
#include "lib/util/loading/factory.h"

#include "debug.h"

CREATE_FACTORY(SimpleSync, CL_SIMPLE_SYNC);


/**
 *  default constructor
 */
SimpleSync::SimpleSync( std::string name )
{
  setName( name );
  this->setClassID( CL_SIMPLE_SYNC, "SimpleSync" );
  in = 0;
  out = 1;
  id = this->registerVarId( new SynchronizeableInt( &in, &out, "var", PERMISSION_ALL ) );
}


/**
 *  default destructor deletes all unneded stuff
 */
SimpleSync::~SimpleSync()
{
}

void SimpleSync::debug( )
{
  printf("IN: %d OUT: %d\n", in, out);
}

SimpleSync::SimpleSync( const TiXmlElement * root )
{
  setName( "" );
  this->setClassID( CL_SIMPLE_SYNC, "SimpleSync" );
  in = 0;
  out = 1;
  id = this->registerVarId( new SynchronizeableInt( &in, &out, "var", PERMISSION_ALL ) );
}



