/*!
 * @file synchronizeable_vector.h
 * @brief Definition of SynchronizeableVector
*/

#include "synchronizeable_var/synchronizeable_var.h"

#ifndef _SYNCHRONIZEABLE_VECTOR_H
#define _SYNCHRONIZEABLE_VECTOR_H

#include "vector.h"

class SynchronizeableVector : public SynchronizeableVar {

  public:
    SynchronizeableVector( Vector * ptrIn, Vector * ptrOut, std::string name, int permission = PERMISSION_SERVER, int priority = 0 );
    virtual ~SynchronizeableVector();
    
    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );
    
    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return true; }
    
    virtual void debug();
    
  private:
    Vector * vPtrIn;       //!< pointer to data (read)
    Vector * vPtrOut;      //!< pointer to data (write)

};

#endif /* _PROTO_CLASS_H */
