/*!
 * @file synchronizeable_string.h
 * @brief Definition of SynchronizeableString
*/

#include "synchronizeable_var/synchronizeable_var.h"
#include "converter.h"

#ifndef _SYNCHRONIZEABLE_STRING_H
#define _SYNCHRONIZEABLE_STRING_H

#include <string>

class SynchronizeableString : public SynchronizeableVar {

  public:
    SynchronizeableString( std::string * ptrIn, std::string * ptrOut, std::string name, int permission = PERMISSION_SERVER, int priority = 0 );
    virtual ~SynchronizeableString();
    
    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );
    
        
    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return false; };
    
    virtual int getSize(){ return vPtrIn->length()+INTSIZE; }
    
    virtual int getSizeFromBuf( byte * buf, int maxLength );
    
    virtual void debug();
    
  private:
    std::string * vPtrIn;       //!< pointer to data (read)
    std::string * vPtrOut;      //!< pointer to data (write)

};

#endif /* _SYNCHRONIZEABLE_STRING_H */
