/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/


#include "synchronizeable_string.h"
#include "converter.h"


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
SynchronizeableString::SynchronizeableString( std::string * ptrIn, std::string * ptrOut, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrOut, name, 0, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrOut;
}


/**
 * standard deconstructor
*/
SynchronizeableString::~SynchronizeableString ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableString::writeToBuf( byte * buf, int maxLength )
{
  int res = Converter::stringToByteArray( *vPtrIn, buf, maxLength );
  
  assert( res > 0 );
  
  return res;
}

/**
 * read var data from byte buffer
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableString::readFromBuf( byte * buf, int maxLength )
{
  std::string oldVal = *vPtrOut;
      
  int res = Converter::byteArrayToString( buf, *vPtrOut, maxLength );
  
  setHasChanged( oldVal != *vPtrOut );
  
  assert( res > 0 );
  
  return res;
}

/**
 * print out variable value
 */
void SynchronizeableString::debug( )
{
  printf( "SYNCHRONIZEABLE_VAR: %s IN: '%s' OUT: '%s'\n", name.c_str(), vPtrIn->c_str(), vPtrOut->c_str() );
}


/**
 * reads actual size from buffer. this is used when size is not constant
 * @param buf pointer to data
 * @param maxLength maximal size of data
 * @return same as readFromBuf would return
 */
int SynchronizeableString::getSizeFromBuf( byte * buf, int maxLength )
{
  std::string t;
  
  int res = Converter::byteArrayToString( buf, t, maxLength );

  
  assert( res > 0 );
  
  return res;
}


