/*!
 * @file synchronizeable_quaternion.h
 * @brief Definition of SynchronizeableQuaternion
*/

#include "synchronizeable_var/synchronizeable_var.h"

#ifndef _SYNCHRONIZEABLE_QUATERNION_H
#define _SYNCHRONIZEABLE_QUATERNION_H

#include "quaternion.h"

class SynchronizeableQuaternion : public SynchronizeableVar {

  public:
    SynchronizeableQuaternion( Quaternion * ptrIn, Quaternion * ptrOut, std::string name, int permission = PERMISSION_SERVER, int priority = 0 );
    virtual ~SynchronizeableQuaternion();
    
    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );
        
    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return true; };
    
    virtual void debug();
    
  private:
    Quaternion * vPtrIn;       //!< pointer to data (read)
    Quaternion * vPtrOut;      //!< pointer to data (write)

};

#endif /* _PROTO_CLASS_H */
