/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/


#include "synchronizeable_int.h"
#include "converter.h"


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
SynchronizeableInt::SynchronizeableInt( int * ptrIn, int * ptrOut, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrOut, name, INTSIZE, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrOut;
}


/**
 * standard deconstructor
*/
SynchronizeableInt::~SynchronizeableInt ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableInt::writeToBuf( byte * buf, int maxLength )
{
  int res = Converter::intToByteArray( *vPtrIn, buf, maxLength );
  
  assert( res == INTSIZE );
  
  return res;
}

/**
 * read var data from byte buffer
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableInt::readFromBuf( byte * buf, int maxLength )
{
  assert( maxLength >= INTSIZE );
  
  int oldVal = *vPtrOut;
  
  int res = Converter::byteArrayToInt( buf, vPtrOut );
  
  setHasChanged( oldVal != *vPtrOut );
  
  assert( res == INTSIZE );
  
  return res;
}


/**
 * print out variable value
 */
void SynchronizeableInt::debug( )
{
  printf( "SYNCHRONIZEABLE_VAR: %s IN: %d OUT: %d\n", name.c_str(), *vPtrIn, *vPtrOut );
}

