/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/


#include "synchronizeable_float.h"
#include "converter.h"


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
SynchronizeableFloat::SynchronizeableFloat( float * ptrIn, float * ptrOut, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrOut, name, FLOATSIZE, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrOut;
}


/**
 * standard deconstructor
*/
SynchronizeableFloat::~SynchronizeableFloat ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableFloat::writeToBuf( byte * buf, int maxLength )
{
  int res = Converter::floatToByteArray( *vPtrIn, buf, maxLength );
  
  assert( res == FLOATSIZE );
  
  return res;
}

/**
 * read var data from byte buffer
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableFloat::readFromBuf( byte * buf, int maxLength )
{
  assert( maxLength >= FLOATSIZE );
  
  float oldVal = *vPtrOut;
  
  int res = Converter::byteArrayToFloat( buf, vPtrOut );
  
  setHasChanged( oldVal != *vPtrOut );
  
  assert( res == FLOATSIZE );
  
  return res;
}


/**
 * print out variable value
 */
void SynchronizeableFloat::debug( )
{
  printf( "SYNCHRONIZEABLE_VAR: %s IN: %f OUT: %f\n", name.c_str(), *vPtrIn, *vPtrOut );
}

