/*!
 * @file synchronizeable_int.h
 * @brief Definition of SynchronizeableInt
*/

#include "synchronizeable_var/synchronizeable_var.h"

#ifndef _SYNCHRONIZEABLE_BOOL_H
#define _SYNCHRONIZEABLE_BOOL_H

class SynchronizeableBool : public SynchronizeableVar {

  public:
    SynchronizeableBool( bool * ptrIn, bool * ptrOut, std::string name, int permission = PERMISSION_SERVER, int priority = 0 );
    virtual ~SynchronizeableBool();
    
    virtual int writeToBuf( byte * buf, int maxLength );
    virtual int readFromBuf( byte * buf, int maxLength );
    
    /**
     * check if writeToBuf will return the same size every time
     * @return true if same size every time
     */
    virtual bool hasStaticSize(){ return true; };
    
    virtual void debug();
    
  private:
    bool * vPtrIn;       //!< pointer to data (read)
    bool * vPtrOut;      //!< pointer to data (write)

};

#endif /* _PROTO_CLASS_H */
