/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/


#include "synchronizeable_bool.h"


/**
 * standard constructor
 */
SynchronizeableBool::SynchronizeableBool( bool * ptrIn, bool * ptrOut, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrOut, name, 1, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrOut;
}


/**
 * standard deconstructor
*/
SynchronizeableBool::~SynchronizeableBool ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableBool::writeToBuf( byte * buf, int maxLength )
{
  assert( maxLength >= 1 );
  
  buf[0] = ( *vPtrIn ) ? 1 : 0;
  
  return 1;
}

/**
 * read var data from byte buffer
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableBool::readFromBuf( byte * buf, int maxLength )
{
  assert( maxLength >= 1 );
  
  bool oldVal = *vPtrOut;
  
  *vPtrOut = buf[0] != 0;
  
  setHasChanged( oldVal != *vPtrOut );
  
  return 1;
}

/**
 * print out variable value
 */
void SynchronizeableBool::debug( )
{
  printf( "SYNCHRONIZEABLE_VAR: %s IN: %d OUT: %d\n", name.c_str(), (int)*vPtrIn, (int)*vPtrOut );
}


