/*!
 * @file message_manager.h
 * @brief Definition of MessageManager
*/

#ifndef _MESSAGE_MANAGER_H
#define _MESSAGE_MANAGER_H

#include "synchronizeable.h"

// FORWARD DECLARATION

//! A class for sending messages over network
class MessageManager : public Synchronizeable {

 public:
   MessageManager();
   virtual ~MessageManager();

   virtual int getStateDiff( int userId, byte* data, int maxLength, int stateId, int fromStateId, int priorityTH );
   virtual int setStateDiff( int userId, byte* data, int length, int stateId, int fromStateId );
   virtual void cleanUpUser( int userId );


 private:

};

#endif /* _PROTO_CLASS_H */
