/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "message_manager.h"

using namespace std;


/**
 * standard constructor
*/
MessageManager::MessageManager ()
{
  this->setClassID( CL_MESSAGE_MANAGER, "MessageManager" );
}


/**
 * standard deconstructor
*/
MessageManager::~MessageManager ()
{
}

/**
 * get the diff to last acked state of userId
 *
 * each synchrinizeable defines its own stack of states received and sent over the network. The stack contains
 * a per user entry for the last sent/received state This function returns a delta compressed state of the
 * synchronizeable. This state will be transmitted over the network to the other participants
 *
 * @param userId user to create diff for
 * @param data buffer to copy diff in
 * @param maxLength max bytes to copy into data
 * @param stateId id of current state
 * @param fromStateId the reference state for the delta state
 * @param priorityTH tells getStateDiff to not send element with priority \< priorityTH
 * @return n bytes copied into data
 */
int MessageManager::getStateDiff( int userId, byte * data, int maxLength, int stateId, int fromStateId, int priorityTH )
{
}

/**
 * sets a new state out of a diff created on another host
 * @param userId hostId of user who send me that diff
 * @param data pointer to diff
 * @param length length of diff
 * @param stateId id of current state
 * @param fromStateId id of the base state id
 * @return number bytes read
 * @todo check for permissions
 */
int MessageManager::setStateDiff( int userId, byte * data, int length, int stateId, int fromStateId )
{
}

/**
 * clean up memory reserved for user
 * @param userId userid
 */
void MessageManager::cleanUpUser( int userId )
{
}
