/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/


#include "synchronizeable_vector.h"
#include "converter.h"


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
SynchronizeableVector::SynchronizeableVector( Vector * ptrIn, Vector * ptrOut, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrOut, name, 3*FLOATSIZE, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrOut;
}


/**
 * standard deconstructor
*/
SynchronizeableVector::~SynchronizeableVector ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableVector::writeToBuf( byte * buf, int maxLength )
{
  int n = 0;
  int res;

  res = Converter::floatToByteArray( vPtrIn->x, buf + n, maxLength - n );
  assert( res > 0 );
  n += res;

  res = Converter::floatToByteArray( vPtrIn->y, buf + n, maxLength - n );
  assert( res > 0 );
  n += res;

  res = Converter::floatToByteArray( vPtrIn->z, buf + n, maxLength - n );
  assert( res > 0 );
  n += res;

  assert( 3*FLOATSIZE == n );

  return n;
}

/**
 * read var data from byte buffer
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableVector::readFromBuf( byte * buf, int maxLength )
{
  assert( maxLength >= 3*FLOATSIZE );

  float x,y,z;

  int res;
  int n = 0;

  res = Converter::byteArrayToFloat( buf + n, &x );
  assert( res > 0 );
  n += res;

  res = Converter::byteArrayToFloat( buf + n, &y );
  assert( res > 0 );
  n += res;

  res = Converter::byteArrayToFloat( buf + n, &z );
  assert( res > 0 );
  n += res;

  *vPtrOut = Vector( x, y, z );

  assert( n == 3*FLOATSIZE );
  return n;
}


/**
 * print out variable value
 */
void SynchronizeableVector::SynchronizeableVector::debug( )
{
  printf( "SYNCHRONIZEABLE_VAR: %s IN: (%f, %f, %f) OUT: (%f %f %f)\n", name.c_str(), vPtrIn->x, vPtrIn->y, vPtrIn->z, vPtrOut->x, vPtrOut->y, vPtrOut->z );
}

