/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/


#include "synchronizeable_quaternion.h"
#include "converter.h"


/**
 * standard constructor
 */
SynchronizeableQuaternion::SynchronizeableQuaternion( Quaternion * ptrIn, Quaternion * ptrOut, std::string name, int permission, int priority) : SynchronizeableVar( ptrIn, ptrOut, name, 4*INTSIZE, permission, priority )
{
  this->vPtrIn = ptrIn;
  this->vPtrOut = ptrOut;
}


/**
 * standard deconstructor
 */
SynchronizeableQuaternion::~SynchronizeableQuaternion ()
{
}

/**
 * write var data to byte buffer
 * @param buf pointer to write to
 * @param maxLength writeToBuf will not write more than maxLength bytes
 * @return number bytes written
 */
int SynchronizeableQuaternion::writeToBuf( byte * buf, int maxLength )
{
  int n = 0;
  int res;

  res = Converter::floatToByteArray( vPtrIn->v.x, buf + n, maxLength - n );
  assert( res > 0 );
  n += res;

  res = Converter::floatToByteArray( vPtrIn->v.y, buf + n, maxLength - n );
  assert( res > 0 );
  n += res;

  res = Converter::floatToByteArray( vPtrIn->v.z, buf + n, maxLength - n );
  assert( res > 0 );
  n += res;

  res = Converter::floatToByteArray( vPtrIn->w, buf +  n, maxLength - n );
  assert( res > 0 );
  n += res;

  assert( 4*FLOATSIZE == n );

  return n;
}

/**
 * read var data from byte buffer
 * @param buf pointer to read from
 * @param maxLength readFromBuf will not read more than maxLength bytes
 * @return number bytes read
 */
int SynchronizeableQuaternion::readFromBuf( byte * buf, int maxLength )
{
  assert( maxLength >= 4*FLOATSIZE );

  float x,y,z,w;

  int res;
  int n = 0;

  res = Converter::byteArrayToFloat( buf + n, &x );
  assert( res > 0 );
  n += res;

  res = Converter::byteArrayToFloat( buf + n, &y );
  assert( res > 0 );
  n += res;

  res = Converter::byteArrayToFloat( buf + n, &z );
  assert( res > 0 );
  n += res;

  res = Converter::byteArrayToFloat( buf + n, &w );
  assert( res > 0 );
  n += res;

  *vPtrOut = Quaternion( Vector(x, y, z), w );

  assert( n == 4*FLOATSIZE );
  return n;
}


/**
 * print out variable value
 */
void SynchronizeableQuaternion::debug( )
{
  printf( "SYNCHRONIZEABLE_VAR: %s IN: ((%f, %f, %f), %f) OUT: ((%f %f %f), %f)\n", name.c_str(), vPtrIn->v.x, vPtrIn->v.y, vPtrIn->v.z, vPtrIn->w, vPtrOut->v.x, vPtrOut->v.y, vPtrOut->v.z, vPtrOut->w );
}

