/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: christoph
   co-programmer:
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

#include "handshake.h"

#include <cassert>

Handshake::Handshake( bool server, int clientId, int networkGameManagerId )
  : Synchronizeable()
{
  /* set the class id for the base object */
  this->setClassID(CL_HANDSHAKE, "Handshake");

  this->setIsServer(server);
  this->localState.hostId = clientId;
  this->localState.networkManagerId = networkGameManagerId;
 
  orxId_handler = registerVarId( new SynchronizeableInt( &localState.orxId, &remoteState.orxId, "orxonoxId", PERMISSION_ALL ) );
  version_handler = registerVarId( new SynchronizeableInt( &localState.version, &remoteState.version, "version", PERMISSION_ALL ) );
  netManId_handler = registerVarId( new SynchronizeableInt( &localState.networkManagerId, &remoteState.networkManagerId, "networkManagerId", PERMISSION_ALL ) );
  hostId_handler = registerVarId( new SynchronizeableInt( &localState.hostId, &remoteState.hostId, "hostId", PERMISSION_ALL ) );
  completed_handler = registerVarId( new SynchronizeableInt( &localState.completed, &remoteState.completed, "completed", PERMISSION_ALL ) );
  error_handler = registerVarId( new SynchronizeableInt( &localState.error, &remoteState.error, "error", PERMISSION_ALL ) );
  errorString_handler = registerVarId( new SynchronizeableString( &localState.errorString, &remoteState.errorString, "errorString", PERMISSION_ALL ) );
  
  localState.completed = false;
  localState.error = 0;
  localState.errorString = "";
  localState.hostId = clientId;
  localState.networkManagerId = networkGameManagerId;
  localState.orxId = _ORXONOX_ID;
  localState.version = _ORXONOX_VERSION;
  
  remoteState.completed = false;
  remoteState.error = 0;
  remoteState.errorString = "";
  remoteState.hostId = -1;
  remoteState.networkManagerId = -1;
  remoteState.orxId = 0;
  remoteState.version = 0;

  this->setSynchronized(true);
  PRINTF(0)("Handshake created clientId = %d\n", clientId);
}

/**
 * handler for changes in synced vars
 * @param id id's which have changed
 */
void Handshake::varChangeHandler( std::list< int > & id )
{
  for ( std::list<int>::iterator it = id.begin(); it != id.end(); it++ )
  {
    if ( *it == orxId_handler )
    {
      if ( remoteState.orxId != _ORXONOX_ID )
      {
        localState.error = 1;
        localState.completed = true;
        localState.errorString = "Seems not to be orxonox!";
        return;
      }
      else
        localState.completed = true;
    }
     
    if ( *it == version_handler )
    {
      if ( remoteState.version != _ORXONOX_VERSION )
      {
        localState.error = 2;
        localState.completed = true;
        localState.errorString = "Versions of server and client do not match!";
        return;
      }
      else
        localState.completed = true;
    }
    
  }
}

