/*!
 * @file file.h
 * @brief Definition of File Handler class
 */

#ifndef __FILE_H_
#define __FILE_H_


#include <string>

class File
{
  public:
  typedef enum
  {
    ReadOnly,
    WriteOnly,
    ReadWrite,
    Append,
  } OpenMode;

public:
  File();
  File(const std::string& fileName);
  File(const File& file);
  ~File();

  virtual bool open(OpenMode mode);
  virtual bool close();
  int handle();

  bool exists();
  bool isLink();      // only on UNIX
  bool isFile();
  bool isDirectory();
  bool isReadeable();
  bool isWriteable();
  bool isExecutable();


  bool copy(const File& destination);
  bool rename(const File& destination);
  bool touch();
  bool remove();

  static void relToAbs(std::string& fileName);
  static void absToRel(std::string& fileName);
  static const std::string& cwd();

  private:
    void homeDirCheck(std::string& fileName);

  private:
    int                 _handle;          //!< The FileHandle (if set).
    std::string         _name;             //!< The Name of the File.

    static std::string  _cwd;             //!< The currend Working directory.
};

#endif /* __FILE_H_ */
