/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "qt_gui.h"

#include <QtGui/QApplication>
#include <QtGui/QToolBox>
#include <QtGui/QGridLayout>

#include "qt_gui_elements.h"
#include "gui_video.h"
#include "gui_audio.h"
#include "gui_general.h"
#include "banner.xpm"
#include <QtGui/QPainter>
#include "q_image_widget.h"

namespace OrxGui
{
  QtGui::QtGui(int argc, char** argv)
  : QApplication(argc, argv)
  {

    this->mainWindow = new QMainWindow();
    this->mainWindow->setMinimumSize(500, 200);

    QGroupBox* groupBox = new QGroupBox(this->mainWindow);
    QGridLayout* mainLayout = new QGridLayout(groupBox);
    {
      QImageWidget* bannerWidget = new QImageWidget();
      QImage bannerImage(banner_xpm);
      bannerImage.save("test.bmp", "bmp");
      bannerWidget->setImage(bannerImage);
      mainLayout->addWidget(bannerWidget, 0,0, 3, 1);


      QToolBox* toolBox = new QToolBox(groupBox);
      {

        toolBox->addItem(new GuiVideo(this), "Video");
        toolBox->addItem(new GuiAudio(this), "Audio");
        toolBox->addItem(new GuiGeneral(this), "General");
      }
      mainLayout->addWidget(toolBox,1,1, 1, 3);


      QPushButton* start = new QPushButton("start");
      connect(start, SIGNAL(released()), this, SLOT(startApp()));
      mainLayout->addWidget(start, 2,2);

      QPushButton* quit = new QPushButton("quit");
      connect(quit, SIGNAL(released()), this, SLOT(quitApp()));
      mainLayout->addWidget(quit, 2,3);

    }

    connect(this->mainWindow, SIGNAL(destroyed()), this, SLOT(quitApp()));
    this->mainWindow->setCentralWidget(groupBox);
    this->mainWindow->show();

    this->loadAll();
    this->exec();
    this->saveAll();

  }

  QtGui::~QtGui()
  {
    this->saveAll();

    delete this->mainWindow;
  }

  void QtGui::startGui()
  {
  }

  void QtGui::stopGui()
  {}

  void QtGui::suspend()
  {}

    //! Update the Gui.
  void QtGui::update()
  {
    this->processEvents();
  }


  void QtGui::quitApp()
  {
    Gui::quitEvent();
    this->quit();
  }

  void QtGui::startApp()
  {
    Gui::startEvent();
    this->quit();
  }

}
