/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "gui_audio.h"

#include <QtGui/QLayout>
#include <QtGui/QLCDNumber>
#include "debug.h"
#include "globals.h"

#include "qt_gui_elements.h"

namespace OrxGui
{
  /**
   *  Creates the Audio-Option-Frame
  */
  GuiAudio::GuiAudio(OrxGui::Gui* gui)
  : Element(CONFIG_SECTION_AUDIO, gui), QGroupBox()
  {
    QGridLayout* layout = new QGridLayout(this);

    {
      QtGuiCheckBox* fullscreen = new QtGuiCheckBox(CONFIG_NAME_DISABLE_AUDIO, this, true);
      layout->addWidget(fullscreen, 0, 1);


      QLabel* soundCardLabel = new QLabel("Soundcard");
      layout->addWidget(soundCardLabel, 1,1);
      QtGuiComboBox* soundCard = new QtGuiComboBox(CONFIG_NAME_SOUNDCARD, this);
      layout->addWidget(soundCard, 2, 1);


      QtGuiSlider* channels = new QtGuiSlider(CONFIG_NAME_AUDIO_CHANNELS, this, Qt::Vertical);
      layout->addWidget(channels, 0, 0, 2, 1);
      QLabel* channelsLabel = new QLabel("Channels");
      layout->addWidget(channelsLabel, 3,0);
      QLCDNumber* channelNumber = new QLCDNumber();
      connect(channels, SIGNAL(valueChanged(int)), channelNumber, SLOT(display(int)));
      layout->addWidget(channelNumber, 2,0);


      QLabel* musicLabel = new QLabel("Music Volume");
      layout->addWidget(musicLabel, 0, 2);
      QtGuiSlider* musicVolume = new QtGuiSlider(CONFIG_NAME_MUSIC_VOLUME, this);
      layout->addWidget(musicVolume, 1, 2);


      QLabel* effectsLabel = new QLabel("Effects Volume");
      layout->addWidget(effectsLabel, 2,2);
      QtGuiSlider* effectVolume = new QtGuiSlider(CONFIG_NAME_EFFECTS_VOLUME, this);
      layout->addWidget(effectVolume, 3, 2);
    }


  }

  /**
   *  Destructs the Audio-stuff
  */
  GuiAudio::~GuiAudio()
  {
    // nothing to do here.
  }


}
