/*
 orxonox - the future of 3D-vertical-scrollers
 
 Copyright (C) 2006 orx
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 ### File Specific:
 main-programmer: bottac@ee.ethz.ch
*/

class SDL_Surface;
class BspTreeNode;
class Vector;
class Material;
class VertexArrayModel;

typedef struct
{
  float x;     //!< 1st component of the plane's normal
  float y;     //!< 2nd component of the plane's normal
  float z;     //!< 3rd component of the plane's normal
  float d;     //!< distance of the plane to the origin
}
plane;

typedef struct
{
  float mins [ 3 ]; //!< Bounding box min coord.
  float maxs [ 3 ]; //!< Bounding box max coord.
  int face;         //!< First face for model.
  int n_faces;      //!< Number of faces for model.
  int brush;        //!< First brush for model.
  int n_brushes;    //!< Number of brushes
}
model;

typedef struct
{
  int plane;        //!< Plane index.
  int left;         //!< 1st Child index. Negative numbers are leaf indices: -(leaf+1).
  int right;        //!< 2nd Child index. Negative numbers are leaf indices: -(leaf+1).
  int mins[ 3 ];    //!< Integer bounding box min coord.
  int maxs[ 3 ];    //!< Integer bounding box max coord.
}
node;

typedef struct
{
  int cluster;            //!< Visdata cluster index.
  int area;               //!< Areaportal area.
  int mins[ 3 ];          //!< Integer bounding box min coord.
  int maxs[ 3 ];          //!< Integer bounding box max coord.
  int leafface;           //!< First leafface for leaf.
  int n_leaffaces;        //!< Number of leaffaces for leaf.
  int leafbrush_first;    //!< leafbrush for leaf.
  int n_leafbrushes;      //!< Number of leafbrushes for leaf.
}
leaf;

struct brush
{
  int brushside; 	//!< First brushside for brush.
  int n_brushsides; 	//!< Number of brushsides for brush.
  int texture; 	        //!< Texture index.
};

typedef struct
{
  int plane;    //!< Plane index.
  int texture; 	//!< Texture index.
}
brushside;

struct face
{
  int texture;    	//!< Texture index.
  int effect; 	        //!< Index into lump 12 (Effects), or -1.
  int type; 	        //!< Face type. 1=polygon, 2=patch, 3=mesh, 4=billboard
  int vertex; 	        //!< Index of first vertex.
  int n_vertexes;       //!< Number of vertices.
  int meshvert;         //!< Index of first meshvert.
  int n_meshverts;      //!< Number of meshverts.
  int lm_index;         //!< Lightmap index.
  int lm_start [ 2 ];   //!< Corner of this face's lightmap image in lightmap.
  int lm_size [ 2 ];     //!< Size of this face's lightmap image in lightmap.
  float lm_origin [ 3 ] ;    //!<  World space origin of lightmap.
  float lm_vecs [ 2 ][ 3 ];  //!< World space lightmap s and t unit vectors.
  float normal[ 3 ];         //!< Surface normal.
  int size [ 2 ] ;           //!< Patch dimensions.
} ;

typedef struct
{
  float position[ 3 ];        //!< Vertex position.
  float texcoord[ 2 ][ 2 ];   //!< Vertex texture coordinates. [0][x]=surface, [1][x]=lightmap.
  float normal[ 3 ];          //!< Vertex normal.
  unsigned char color [ 4 ];  //!< Vertex color. RGBA.
}
BspVertex;

typedef struct
{
  int offset;
}
meshvert;                    //!< Integer offset to mesh vertex

typedef struct
{
  float position [ 3 ];
}
BspVec;

typedef struct
{
  Material* mat;
  bool alpha;
}
AMat;

typedef struct
{
  unsigned char map [128][128][3];
}
lightmap;

typedef struct
{
  char name[64];
  int flags;
  int contents;
}
BspTexture;

class BspFile
{
  friend class BspManager;

public:
  BspFile();
  int read(const char* name );
  void build_tree();
  void load_textures();
  void tesselate( int iface );
  BspTreeNode* get_root();
  AMat loadMat( char* mat );


private:
  BspTreeNode* root;
  char header [ 280 ];       //!< Buffer for header of BSP-File
  node* nodes;               //!< Buffer to store BSP-Tree-Nodes
  leaf* leaves;              //!< Buffer to store BSP-Tree-Leaves
  plane* planes;             //!< Buffer to store planes separateing the space
  model* bspModels;          //!< Buffer to store BSP-Model-List
  char* leafFaces;           //!< Buffer to store leafFaces
  face* faces;               //!<
  char* leafBrushes;         //!< Buffer to store brush indice
  brush* brushes;            //!< Buffer to store  brushes
  brushside* brushSides;     //!<
  char* vertice;             //!<
  meshvert* meshverts;       //!< Buffer to store meshverice
  char* visData;             //!< Buffer to store visibility data
  char* textures;            //!< Holds all the texture filename strings
  char* patchVertice;        //!<
  char* patchIndexes;
  char* patchTrianglesPerRow;
  lightmap* lightMaps;       //!< Buffer to store lightmap-images


  int** patchRowIndexes;
  VertexArrayModel** VertexArrayModels;
  int patchOffset;

  int numNodes;
  int numLeafs;
  int numVertex;
  int numPlanes;
  int numBspModels;
  int numLeafFaces;
  int numFaces;
  int numLeafBrushes;
  int numTextures;
  int numPatches;
  int numBrushSides;
  int numLightMaps;



  BspTreeNode* build_tree_rec( int i );
  unsigned int loadLightMapToGL(lightmap&);
  AMat* Materials;
  unsigned int* glLightMapTextures;
  unsigned int whiteLightMap;
  unsigned char whiteTexture[3];
  SDL_Surface* testSurf;

};

