/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "qt_gui_elements.h"


namespace OrxGui
{



  QtGuiCheckBox::QtGuiCheckBox(const std::string& name, SaveableGroup* group, bool defaultValue)
  : QCheckBox(QString().fromStdString(name)), Saveable(name, group)
  {
    //this->load(this->value());
  }

  void QtGuiCheckBox::load(const MultiType& value)
  {
    this->setTristate(value.getBool());
    this->value() = value;
  }



  const MultiType& QtGuiCheckBox::save()
  {
    return this->value();
  }





  QtGuiSlider::QtGuiSlider(const std::string& name, SaveableGroup* group, Qt::Orientation orientation)
  : QSlider(orientation), Saveable(name, group)
  {

  }
  QtGuiSlider::~QtGuiSlider()
  {}








  QtGuiComboBox::QtGuiComboBox(const std::string& name, SaveableGroup* group)
  : QComboBox(), Saveable(name, group)
  {


  }

  void QtGuiComboBox::load(const MultiType& value)
  {
    this->value() = value;
    //TODO
  }

  const MultiType& QtGuiComboBox::save()
  {
    return this->value();
  }


  QtGuiInputLine::QtGuiInputLine(const std::string& name, SaveableGroup* group)
  : QLineEdit(), Saveable(name, group)
  {


  }


  void QtGuiInputLine::load(const MultiType& value)
  {
    this->setText(value.getString().c_str());
    this->value() = value;
  }



  const MultiType& QtGuiInputLine::save()
  {
    return this->value();
  }




}
