/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "gui_general.h"

#include <QtGui/QLayout>
#include "debug.h"

#include "qt_gui_elements.h"

namespace OrxGui
{
  /**
   *  Creates the General-Option-Frame
  */
  GuiGeneral::GuiGeneral(OrxGui::Gui* gui)
  : Element("General", gui), QGroupBox()
  {
    QGridLayout* layout = new QGridLayout(this);

    {
      QLabel* dataDirLabel = new QLabel("DataDirectory");
      layout->addWidget(dataDirLabel, 0,0);
      QtGuiInputLine* dataDir = new QtGuiInputLine("SoundCard", this);
      layout->addWidget(dataDir, 0, 1, 1, 2);

      QLabel* debugLabel = new QLabel("debug-mode");
      layout->addWidget(debugLabel, 1,0);
      QtGuiComboBox* debug = new QtGuiComboBox("debug", this);
      layout->addWidget(debug, 1, 1, 1, 2);

      debug->addItem("0 - minimal");
      debug->addItem("1 - errors");
      debug->addItem("2 - warnings");
      debug->addItem("3 - information");
      debug->addItem("4 - debug");
      debug->addItem("5 - extremely debug");
    }


  }

  /**
   *  Destructs the General-stuff
  */
  GuiGeneral::~GuiGeneral()
  {
    // nothing to do here.
  }


}
