/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: hdavid, amaechler
*/

#include "rain_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "glincl.h"

// *****

#include "material.h"
#include "state.h"
#include "shell_command.h"

#include "parser/tinyxml/tinyxml.h"
#include <algorithm>

using namespace std;

CREATE_FACTORY(RainEffect, CL_RAIN_EFFECT);

RainEffect::RainEffect(const TiXmlElement* root)
{
  this->setClassID(CL_RAIN_EFFECT, "RainEffect");

//   this->rainMode = GL_LINEAR;
//   this->rainDensity = 0.001f;
//   this->rainStart = 10.0f;
//   this->rainEnd = 1000.0f;

  if (root != NULL)
    this->loadParams(root);

  this->activate();
}



RainEffect::~RainEffect()
{
  this->deactivate();
}


void RainEffect::loadParams(const TiXmlElement* root)
{
  WeatherEffect::loadParams(root);

//   LoadParam(root, "rain-mode", this, RainEffect, setRainMode);
//   LoadParam(root, "rain-density", this, RainEffect, setRainDensity);
//   LoadParam(root, "rain-color", this, RainEffect, setRainColor);


}

bool RainEffect::init()
{}



bool RainEffect::activate()
{
  PRINTF(0)("Activating Rain Effect\n");
}


bool RainEffect::deactivate()
{
  PRINTF(0)("Deactivating Rain Effect\n");
// 	glDisable(GL_RAIN);
}

void RainEffect::draw() const
{
//  Particle* drawPart = ParticleSystem::particles;

//   glDepthMask(GL_FALSE);
//   glPushAttrib(GL_ENABLE_BIT);
// 
//   glDisable(GL_LIGHTING);
//   glDisable(GL_TEXTURE_2D);
// 
//   glEnable(GL_LINE_SMOOTH);
//   glEnable(GL_BLEND);
//   glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);
// 
//   glLineWidth(2.0);
//   glBegin(GL_LINES);
//   while (likely(drawPart != NULL))
//   {
//   //    printf("%f %f %f %f\n", drawPart->color[0], drawPart->color[1], drawPart->color[2], drawPart->color[3]);
//     glColor4fv(drawPart->color);
//     glVertex3f(drawPart->position.x,  drawPart->position.y,  drawPart->position.z);
//     glVertex3f(drawPart->position.x - drawPart->velocity.x * drawPart->radius,
//                drawPart->position.y - drawPart->velocity.y * drawPart->radius,
//                drawPart->position.z - drawPart->velocity.z * drawPart->radius);
//     drawPart = drawPart->next;
//   }
//   glEnd();
// 
//   glDepthMask(GL_TRUE);
//   glPopAttrib();
}
