/*!
 * @file qt_gui_elements.h
 * @brief Definition of ...
*/

#ifndef __QT_GUI_ELEMENTS_H
#define __QT_GUI_ELEMENTS_H

#include "../gui_saveable.h"
#include <list>

// grouping
#include <QtGui/QGroupBox>
#include <QtGui/QProgressBar>
#include <QtGui/QLabel>

// events
#include <QtGui/QPushButton>

// options
#include <QtGui/QCheckBox>
#include <QtGui/QSlider>
#include <QtGui/QLineEdit>
#include <QtGui/QComboBox>

namespace OrxGui
{
  class QtGuiCheckBox : public QCheckBox, public Saveable
  {
    Q_OBJECT
  public:
    QtGuiCheckBox(const std::string& name, SaveableGroup* group, bool defaultValue = false);
    virtual ~QtGuiCheckBox() {};

    virtual void load(const MultiType& value);
    virtual const MultiType& save();

  public slots:
    //    void setCheckValue(int);

  signals:
    //    void checkValueChanged();
  };

  class QtGuiSlider : public QSlider, public Saveable
  {
    Q_OBJECT

  public:
    QtGuiSlider(const std::string& name, SaveableGroup* group, Qt::Orientation orientation = Qt::Horizontal);
    virtual ~QtGuiSlider();

  public slots:
    //   void setSliderValue(float);

  signals:
    //    void sliderValueChanged(float);
  };


  class QtGuiComboBox : public QComboBox, public OrxGui::Saveable
  {
    Q_OBJECT

  public:
    QtGuiComboBox(const std::string& name, SaveableGroup* group);

    virtual void load(const MultiType& value);
    virtual const MultiType& save();
  };

}

#endif /* __QT_GUI_ELEMENTS_H */
