/*!
 * @file gui_saveable.h
 * @brief Definition of ...
*/

#ifndef _GUI_SAVEABLE_H
#define _GUI_SAVEABLE_H

#include "base_object.h"
#include "lib/util/multi_type.h"
#include <vector>

// FORWARD DECLARATION
namespace OrxGui
{
  class Gui;
  class SaveableGroup;

  //! A class for Elements in the Gui that are Saveable.
  class Saveable : public BaseObject
  {
  public:
    virtual ~Saveable();

    void makeSaveable();

    virtual void load(const MultiType& value) {};
    virtual const MultiType& save() {};

    MultiType&       value() { return this->_value; };
    const MultiType& value() const { return this->_value; };
    bool             isSaveable() const { return this->bSaveable; };

  protected:
    Saveable(const std::string& optionName, SaveableGroup* group);
    virtual void makingElementSaveable() {};

  private:
    SaveableGroup*  group;
    MultiType       _value;
    bool            bSaveable;
  };



  class SaveableGroup : public BaseObject
  {
  public:
    virtual ~SaveableGroup();

    void addSaveable(Saveable* saveable);
    void removeSaveable(Saveable* saveable);

    virtual void load(const MultiType& value);
    virtual const MultiType& save();

  protected:
    SaveableGroup(const std::string& name, OrxGui::Gui* gui);

  private:
    OrxGui::Gui*                        gui;
    std::vector<Saveable*>              saveables;
  };

}
#endif /* _GUI_SAVEABLE_H */
