/*!
 * @file gui.h
 * @brief Definition of ...
*/

#ifndef _GUI_H
#define _GUI_H

#include "base_object.h"
#include <vector>

// FORWARD DECLARATION

namespace OrxGui
{
  class SaveableGroup;

  //! A class for ...
  class Gui : public BaseObject
  {
  public:
    typedef enum {
      Null          = 0,
      Quitting      = 1,
      Starting      = 2,
      Saving        = 4,
    } State;


  public:
    Gui();
    virtual ~Gui();

    //! Start the Gui
    virtual void startGui() = 0;
    //! Stop the gui
    virtual void stopGui() = 0;
    //! Suspend the Gui.
    virtual void suspend() = 0;
    //! Update the Gui.
    virtual void update() = 0;

    unsigned int getState() const { return this->state; };


    void addSaveableGroup(SaveableGroup* saveableGroup);
    void removeSaveableGroup(SaveableGroup* saveableGroup);

  protected:
    void quitEvent();
    void startEvent();

  private:
    unsigned int                  state; //!< The State the Gui is in.
    std::vector<SaveableGroup*>   groups;
  };
}
#endif /* _GUI_H */
