/*!
 * @file qt_gui_elements.h
 * @brief Definition of ...
*/

#ifndef __QT_GUI_ELEMENTS_H
#define __QT_GUI_ELEMENTS_H

#include "base_object.h"
#include "../gui_saveable.h"
#include <list>

// grouping
#include <qgroupbox.h>
#include <qprogressbar.h>
#include <qlabel.h>

// events
#include <qpushbutton.h>

// options
#include <qcheckbox.h>
#include <qslider.h>
#include <qlineedit.h>

namespace OrxGui
{

  class QtGuiWidget : virtual public BaseObject
  {
  public:
  };


  class QtGuiContainer : public QtGuiWidget
  {
  public:
    virtual bool pack(QtGuiWidget* widget) = 0;

  protected:
    QtGuiContainer();
    ~QtGuiContainer();

  private:

  };


  typedef enum Orientation
  {
    horizontal,
    vertical
  };

  class QtGuiBox : public QtGuiContainer, public GuiSaveableGroup
  {

  public:
    QtGuiBox(Orientation orientation);
    ~QtGuiBox();

    virtual bool pack(QtGuiWidget* widget);

  private:
    std::list<QtGuiWidget*>   children;

  };

  class QtGuiGroupBox : public QtGuiContainer, public GuiSaveableGroup
  {
  public:
    QtGuiGroupBox(const std::string& groupName);
    ~QtGuiGroupBox();

    virtual bool pack(QtGuiWidget* widget);

  private:
    QtGuiWidget*              child;
  };



  class QtGuiCheckBox : public QCheckBox, public QtGuiWidget, public GuiSaveable
  {
  public:
    QtGuiCheckBox(const std::string& name, bool defaultValue = false);
    ~QtGuiCheckBox();

  public slots:
    void setCheckValue(int);

  signals:
    void checkValueChanged();
  };


  class QtGuiPushButtom : public QPushButton, public QtGuiWidget
  {
  public:
    QtGuiPushButtom();
    ~QtGuiPushButtom();
  };

  class QtGuiSlider : public QSlider, public QtGuiWidget, public GuiSaveable
  {
  public:
    QtGuiSlider();
    ~QtGuiSlider();

  public slots:
    void setSliderValue(float);

  signals:
    void sliderValueChanged(float);
  };


  class QtGuiComboBox : public QComboBox, public OrxGui::Saveable
  {
    QtGuiComboBox(QWidget* parent, const std::string& name);
  }



  class QtGuiTextLine : public QLineEdit, public QtGuiWidget, public GuiSaveable
  {
  public:
    QtGuiTextLine();
    ~QtGuiTextLine();

  public slots:
    void setTextLineValue(const char*);
  signals:
    void textLineChanged(const char*);
  };



  class QtGuiImage : public QtGuiWidget
  {
  }
  ;
}

#endif /* __QT_GUI_ELEMENTS_H */
