/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "qt_gui.h"

#include <qapplication.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qtoolbox.h>

#include <qpushbutton.h>
#include <qcombobox.h>

#include "gui_video.h"
#include "gui_audio.h"

namespace OrxGui
{
  QtGui::QtGui(int argc, char** argv)
  : QApplication(argc, argv)
  {

    this->mainWindow = new QMainWindow();


    QGroupBox* groupBox = new QGroupBox(this->mainWindow);
    QGridLayout* mainLayout = new QGridLayout(groupBox);
    {
      QToolBox* toolBox = new QToolBox(groupBox);
      {

        toolBox->addItem(new GuiVideo(toolBox), "Video");
        toolBox->addItem(new GuiAudio(toolBox), "Audio");
      }
      mainLayout->addWidget(toolBox,1,1);
    }

    this->mainWindow->setCentralWidget(groupBox);
    this->mainWindow->show();

    this->exec();


  }

  QtGui::~QtGui()
  {
    delete this->mainWindow;
  }

  void QtGui::startGui()
  {}

  void QtGui::stopGui()
  {}

  void QtGui::suspend()
  {}

    //! Update the Gui.
  void QtGui::update()
  {
    this->processEvents();
  }

}
