/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "gui_video.h"

#include <qlayout.h>
#include "sdlincl.h"
#include "debug.h"

#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>

namespace OrxGui
{
  /**
   *  Creates the Video-Option-Frame
  */
  GuiVideo::GuiVideo(QWidget* parent)
  : Element("Video"), QGroupBox(parent)
  {
    QGridLayout* layout = new QGridLayout(this);

    {
      QCheckBox* fullscreen = new QCheckBox(QString("FullScreen"), this);
      //fullscreen->setName();
      layout->addWidget(fullscreen, 0, 0);

      QCheckBox* wireframe = new QCheckBox("Wireframe mode", this);
      layout->addWidget(wireframe, 1, 0);

      {
        QComboBox* resolution = new QComboBox("Resolution", this);
        layout->addWidget(resolution, 2, 0);
        std::vector<QString> resolutions;
        this->getResolutions(resolutions);
        for (unsigned int i = 0; i < resolutions.size(); ++i)
          resolution->insertItem(resolutions[i]);
      }

    }



/*    Frame* videoFrame;        //!< The Frame that holds the video options.

    videoFrame = new Frame("Video-Options:");
    videoFrame->setGroupName("video");
    {
      Box* videoBox;            //!< The Box that holds the video options.

      videoBox = new Box('v');
      {
        CheckButton* fullscreen;  //!< CheckButton for fullscreen-mode
        Menu* resolution;         //!< Menu for the resolution
        CheckButton* wireframe;   //!< CheckButton for wireframe Mode.

        fullscreen = new CheckButton(CONFIG_NAME_FULLSCREEN);
        fullscreen->setFlagName("windowed", "q", 1);
        fullscreen->setDescription("Starts orxonox in windowed mode");
        fullscreen->saveability();
        videoBox->fill(fullscreen);
        resolution = new Menu(CONFIG_NAME_RESOLUTION);
        getResolutions(resolution);
        resolution->saveability();
        resolution->setFlagName("resolution", "r", 0);
        resolution->setDescription("Sets the resolution of orxonox");
        videoBox->fill(resolution);
        wireframe = new CheckButton(CONFIG_NAME_WIREFRAME);
        wireframe->setFlagName("wireframe", "w", 0);
        wireframe->setDescription("Starts orxonox in wireframe mode");
        wireframe->saveability();
        videoBox->fill(wireframe);

        videoBox->fill(advancedWindowCreate());
      }
      videoFrame->fill(videoBox);
    }
    setMainWidget(videoFrame);*/
  }

  /**
   *  Destructs the Video-stuff
  */
  GuiVideo::~GuiVideo()
  {
    // nothing to do here.
  }

  /**
   *  sets all resolutions to the menu
   * @param menu the Menu to set The resolutions to.
  */
  void GuiVideo::getResolutions(std::vector<QString>& resolutionList)
  {
    SDL_Init(SDL_INIT_VIDEO);
    SDL_Rect **modes;
    int i;
    int x = 0,y =0; // check for difference
    char tmpChar[100];

    /* Get available fullscreen/hardware modes */
    modes=SDL_ListModes(NULL, SDL_FULLSCREEN|SDL_HWSURFACE);

    /* Check is there are any modes available */
    if(modes == (SDL_Rect **)0)
    {
      PRINTF(2)("No video-modes available!\n");
      exit(-1);
    }

    /* Check if our resolution is restricted */
    if(modes == (SDL_Rect **)-1)
    {
      PRINTF(2)("All resolutions available.\n");
    }
    else
    {
      /* Print valid modes */
      PRINT(5)("Available Modes\n");
      for(i = 0; modes[i] ;++i)
      {
        if (x != modes[i]->w || y != modes[i]->h)
        {
          PRINTF(5)("  %d x %d\n", modes[i]->w, modes[i]->h);
          sprintf(tmpChar, "%dx%d", modes[i]->w, modes[i]->h);
          resolutionList.push_back(std::string(tmpChar));
          x = modes[i]->w; y = modes[i]->h;
        }
      }
    }
    SDL_QuitSubSystem(SDL_INIT_VIDEO);
    SDL_Quit();
  }

}
