/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: hdavid, amaechler
*/

#include "fog_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "glincl.h"

#include "shell_command.h"
/*SHELL_COMMAND(activateFog, FogEffect, FogEffect::activate)
  ->setAlias("aFog");
SHELL_COMMAND(deactivateFog, FogEffect, FogEffect::deactivate)
  ->setAlias("dFog");*/

using namespace std;

CREATE_FACTORY(FogEffect, CL_FOG_EFFECT);

FogEffect::FogEffect(const TiXmlElement* root)
{
  this->setClassID(CL_FOG_EFFECT, "FogEffect");
  
  this->fogMode = GL_LINEAR;
  this->fogDensity = 0.001f;
  this->fogStart = 10.0f;
  this->fogEnd = 1000.0f;

  if (root != NULL)
    this->loadParams(root);

  this->activate();
}



FogEffect::~FogEffect()
{
  this->deactivate();
}


void FogEffect::loadParams(const TiXmlElement* root)
{
  WeatherEffect::loadParams(root);

  LoadParam(root, "fog-mode", this, FogEffect, setFogMode);
  LoadParam(root, "fog-density", this, FogEffect, setFogDensity);
  LoadParam(root, "fog-color", this, FogEffect, setFogColor);


}

bool FogEffect::init()
{}



bool FogEffect::activate()
{
  PRINTF(0)( "Enabling Fog Effect, mode: %i, density: %f, start: %f, end: %f, color %f, %f, %f\n", this->fogMode, this->fogDensity,
             this->fogStart, this->fogEnd, this->colorVector.x, this->colorVector.y, this->colorVector.z);

  glEnable(GL_FOG);
  {
    //GLfloat fogColor[4] = {0.7, 0.6, 0.6, 1.0};
    GLfloat fogColor[4] = { colorVector.x, colorVector.y, colorVector.z, 1.0};

    glFogi(GL_FOG_MODE, this->fogMode);
    glFogfv(GL_FOG_COLOR, fogColor);
    glFogf(GL_FOG_DENSITY, this->fogDensity);
    glHint(GL_FOG_HINT, GL_DONT_CARE);
    glFogf(GL_FOG_START, this->fogStart);
    glFogf(GL_FOG_END, this->fogEnd);

    //glFogi(GL_FOG_COORDINATE_SOURCE, GL_FOG_COORDINATE);
  }
  glClearColor(0.5, 0.5, 0.5, 1.0);
}


bool FogEffect::deactivate()
{
  PRINTF(0)("Deactivating Fog Effect\n");
	glDisable(GL_FOG);
}



GLint FogEffect::stringToFogMode(const std::string& mode)
{
  if(mode == "GL_LINEAR")
    return GL_LINEAR;
  else if(mode == "GL_EXP")
    return GL_EXP;
  else if(mode == "GL_EXP2" )
    return GL_EXP2;
  else
    return -1;
}


