/*!
 * @file substring.h
 * @brief a small class to get the parts of a string separated by commas
 */

#ifndef _SUBSTRING_H
#define _SUBSTRING_H

#include <vector>
#include <string>


//! A class that can load one string and split it in multipe ones
/**
 * SubString is a very Powerfull way to create a SubSet from a String
 * It can be used, to Split strings append them and join them again.
 */
class SubString
{
public:
  typedef enum {
    SL_NORMAL,
    SL_ESCAPE,
    SL_SAFEMODE,
    SL_SAFEESCAPE,
    SL_COMMENT,
  } SPLIT_LINE_STATE;


public:
  SubString();
  SubString(const std::string& string, char delimiter = ',');
  SubString(const std::string& string,
            const std::string& delimiters, const std::string& delimiterNeighbours = "", bool emptyEntries=false,
            char escapeChar ='\\', char safemode_char = '"', char comment_char = '\0');
  /** @brief create a Substring as a copy of another one. @param subString the SubString to copy. */
  SubString(unsigned int argc, const char** argv);
  SubString(const SubString& subString) { *this = subString; };
  SubString(const SubString& subString, unsigned int subSetBegin);
  SubString(const SubString& subString, unsigned int subSetBegin, unsigned int subSetEnd);
  ~SubString();

  // operate on the SubString
  SubString& operator=(const SubString& subString);
  bool operator==(const SubString& subString) const;
  bool compare(const SubString& subString) const;
  bool compare(const SubString& subString, unsigned int length) const;
  SubString operator+(const SubString& subString) const;
  SubString& operator+=(const SubString& subString);
  /** @param subString the String to append @returns appended String. @brief added for convenience */
  SubString& append(const SubString subString) { return (*this += subString); };

  /////////////////////////////////////////
  // Split and Join the any String. ///////
  unsigned int split(const std::string& string = "", char delimiter = ',');
  unsigned int split(const std::string& string,
                     const std::string& delimiters, const std::string& delimiterNeighbours = "", bool emptyEntries = false,
                     char escapeChar ='\\', char safemode_char = '"', char comment_char = '\0');
  std::string join(const std::string& delimiter = " ") const;
  ////////////////////////////////////////

  // retrieve a SubSet from the String
  SubString getSubSet(unsigned int subSetBegin) const;
  SubString getSubSet(unsigned int subSetBegin, unsigned int subSetEnd) const;

  // retrieve Information from within
  /** @returns true if the SubString is empty */
  inline bool empty() const { return this->strings.empty(); };
  /** @returns the count of Strings stored in this substring */
  inline unsigned int size() const { return this->strings.size(); };
  /** @param i the i'th String @returns the i'th string from the subset of Strings */
const std::string& operator[](unsigned int i) const { return (i < this->strings.size()) ? this->strings[i] : emptyString;return this->getString(i); };
  /** @param i the i'th String @returns the i'th string from the subset of Strings */
  const std::string& getString(unsigned int i) const { return (*this)[i]; };

  // the almighty algorithm.
  static SPLIT_LINE_STATE splitLine(std::vector<std::string>& ret,
                                    const std::string& line,
                                    const std::string& delimiters = SubString::WhiteSpaces,
                                    const std::string& delimiterNeighbours = "",
                                    bool emptyEntries = false,
                                    char escape_char = '\\',
                                    char safemode_char = '"',
                                    char comment_char = '\0',
                                    SPLIT_LINE_STATE start_state = SL_NORMAL);
  // debugging.
  void debug() const;

public:
  static const std::string WhiteSpaces;
  static const std::string WhiteSpacesWithComma;

private:
  std::vector<std::string>  strings;                      //!< strings produced from a single string splitted in multiple strings

  static const std::string emptyString;
};

#endif /* _SUBSTRING_H */
