/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: Benjamin Grauer
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_LOADING

#include "util/loading/factory.h"

//#include "shell_command.h"

using namespace std;

//SHELL_COMMAND(create, Factory, fabricate);

/**
 * @brief constructor
 *
 * set everything to zero and define factoryName
 */
Factory::Factory (const std::string& factoryName, ClassID classID)
  : className(factoryName), classID(classID)
{
  this->setClassID(CL_FACTORY, "Factory");
  this->setName(factoryName);

  if( Factory::factoryList == NULL)
    Factory::factoryList = new std::list<Factory*>;

  Factory::factoryList->push_back(this);
}

/** @brief a reference to the First Factory */
std::list<Factory*>* Factory::factoryList = NULL;

/**
 * @brief destructor
 */
Factory::~Factory ()
{
  //  printf("%s\n", this->factoryName);
  //  Factory* tmpDel = this->next;
  //  this->next = NULL;
}

/**
 * @brief deletes all the Factories. (cleanup)
 */
void Factory::deleteFactories()
{
  if (Factory::factoryList != NULL)
  {
    while(!Factory::factoryList->empty())
    {
      delete Factory::factoryList->front();
      Factory::factoryList->pop_front();
    }
    delete Factory::factoryList;
    Factory::factoryList = NULL;
  }
}

/**
 * @param classID match a classID with this classID
 * @returns true on match, false otherwise
 */
bool Factory::operator==(ClassID classID) const
{
  return (this->classID == classID);
}

/**
 * @brief Compares the Factories Name against a given ClassName
 * @param className the Name of the Class to Query
 * @returns true on match, false otherwise.
 */
bool Factory::operator==(const char* className) const
{
  return(className != NULL && this->className == className);
}

/**
 * @brief Compares the Factories Name against a given ClassName
 * @param className the Name of the Class to Query
 * @returns true on match, false otherwise.
 */
bool Factory::operator==(const std::string& className) const
{
  return(this->className == className);
}


/**
 * @brief Creates a new Object of type root->Value() (name)
 * @param root the XML-Root to match for the newly created Object
 * @returns a new Object of Type root->Value() on match, NULL otherwise
 */
 BaseObject* Factory::fabricate(const TiXmlElement* root)
{
  if (root == NULL || Factory::factoryList == NULL)
    return NULL;

  std::list<Factory*>::const_iterator factory;
  for (factory = Factory::factoryList->begin(); factory != Factory::factoryList->end(); factory++)
    if (*(*factory) == root->Value())
      break;

  if (factory != Factory::factoryList->end())
  {
    PRINTF(2)("Create a new Object of type %s\n", (*factory)->getName());
    return (*factory)->fabricateObject(root);
  }
  else
  {
    PRINTF(2)("Could not Fabricate an Object of Class '%s'\n", root->Value());
    return NULL;
  }
}


/**
 * Creates a new Object of type className
 * @param className the ClassName to match for the newly created Object
 * @returns a new Object of Type className on match, NULL otherwise
 */
 BaseObject* Factory::fabricate(const std::string& className)
{
  if (Factory::factoryList == NULL)
    return NULL;

  std::list<Factory*>::const_iterator factory;
  for (factory = Factory::factoryList->begin(); factory != Factory::factoryList->end(); factory++)
    if (*(*factory) == className)
      break;

  if (factory != Factory::factoryList->end())
  {
    PRINTF(4)("Create a new Object of type %s\n", (*factory)->getName());
    return (*factory)->fabricateObject(NULL);
  }
  else
  {
    PRINTF(2)("Could not Fabricate an Object of Class '%s'\n", className);
    return NULL;
  }
}


/**
 * Creates a new Object of type classID
 * @param classID the ClassID to match for the newly created Object
 * @returns a new Object of Type classID on match, NULL otherwise
 */
BaseObject* Factory::fabricate(ClassID classID)
{
  if (Factory::factoryList == NULL)
    return NULL;

  std::list<Factory*>::const_iterator factory;
  for (factory = Factory::factoryList->begin(); factory != Factory::factoryList->end(); factory++)
    if (*(*factory) == classID)
      break;

  if (factory != Factory::factoryList->end())
  {
    PRINTF(4)("Create a new Object of type %s\n", (*factory)->getName());
    return (*factory)->fabricateObject(NULL);
  }
  else
  {
    PRINTF(2)("Could not Fabricate an Object of ClassID '0x%h'\n", classID);
    return NULL;
  }
}
