/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
 * @file some_shell_commands.cc
 * @brief All the ShellCommands, that should not pollute the SourceCode.
 */

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "shell/shell_command.h"
using namespace OrxShell;



#include "class_list.h"
  SHELL_COMMAND_STATIC(debug, ClassList, ClassList::debugS)
      ->describe("Shows all registered classes, if param1: is a valid ClassName only values of this class are shown. param2: how much output")
      ->defaultValues(MT_NULL, 1);

#include "p_node.h"
  SHELL_COMMAND(debugNode, PNode, debugNodeSC);
  SHELL_COMMAND(setPosition, PNode, setAbsCoor);

#include "render_2d.h"
  SHELL_COMMAND(toggleNodeVisibility, Render2D, toggleNodesVisibility);


#include "material.h"
  SHELL_COMMAND(setDiffuseTexture, Material, setDiffuseMap)
      ->defaultValues(MT_NULL, (int)GL_TEXTURE_2D)
      ->completionPlugin(0, CompletorFileSystem());

